package com.xebialabs.xlrelease.configuration;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(label = "Limits", root = CONFIGURATION, versioned = false,
        description = "Limits configuration for resource quotas and constraints")
public class TenantLimit extends BaseConfigurationItem {

    @Property(label = "Tenant ID", description = "Unique identifier for the tenant", category = "tenant")
    private String tenantId;

    @Property(label = "Limits Enabled", description = "Whether tenant limits enforcement is enabled", category = "tenant", defaultValue = "true")
    private boolean enabled;

    @Property(label = "Maximum Folders", category = "folder", defaultValue = "-1", description = "Maximum number of folders allowed")
    private int maxFolders;

    @Property(label = "Maximum Connections", category = "connection", defaultValue = "-1", description = "Maximum number of connections allowed")
    private int maxConnections;

    @Property(label = "Maximum Templates", category = "release", defaultValue = "-1", description = "Maximum number of templates allowed")
    private int maxTemplates;

    @Property(label = "Maximum Running Releases", category = "release", defaultValue = "-1", description = "Maximum number of running releases allowed")
    private int maxRunningReleases;

    @Property(label = "Maximum Template Phases", category = "release", defaultValue = "-1", description = "Maximum number of phases allowed per template")
    private int maxTemplatePhases;

    @Property(label = "Maximum Template Tasks", category = "release", defaultValue = "-1", description = "Maximum number of tasks allowed per template")
    private int maxTemplateTasks;

    @Property(label = "Maximum Release Phases", category = "release", defaultValue = "-1", description = "Maximum number of phases allowed per release")
    private int maxReleasePhases;

    @Property(label = "Maximum Release Tasks", category = "release", defaultValue = "-1", description = "Maximum number of tasks allowed per release")
    private int maxReleaseTasks;

    @Property(label = "Maximum Workflow Templates", category = "workflow", defaultValue = "-1", description = "Maximum number of workflow templates allowed")
    private int maxWorkflowTemplates;

    @Property(label = "Maximum Workflow Executions", category = "workflow", defaultValue = "-1", description = "Maximum number of workflow executions allowed")
    private int maxWorkflowExecutions;

    @Property(label = "Maximum Workflow Phases", category = "workflow", defaultValue = "-1", description = "Maximum number of phases allowed per workflow")
    private int maxWorkflowPhases;

    @Property(label = "Maximum Workflow Tasks", category = "workflow", defaultValue = "50", description = "Maximum number of tasks allowed per workflow")
    private int maxWorkflowTasks;

    @Property(label = "Maximum Workflow Execution Phases", category = "workflow", defaultValue = "-1", description = "Maximum number of phases allowed per workflow execution")
    private int maxWorkflowExecutionPhases;

    @Property(label = "Maximum Workflow Execution Tasks", category = "workflow", defaultValue = "500", description = "Maximum number of tasks allowed per workflow execution")
    private int maxWorkflowExecutionTasks;

    @Property(label = "Maximum Triggers", category = "trigger", defaultValue = "-1", description = "Maximum number of triggers allowed")
    private int maxTriggers;

    @Property(label = "Maximum Patterns", category = "delivery", defaultValue = "-1", description = "Maximum number of patterns allowed")
    private int maxPatterns;

    @Property(label = "Maximum Deliveries", category = "delivery", defaultValue = "-1", description = "Maximum number of deliveries allowed")
    private int maxDeliveries;

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(final String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(final boolean enabled) {
        this.enabled = enabled;
    }

    public int getMaxRunningReleases() {
        return maxRunningReleases;
    }

    public void setMaxRunningReleases(final int maxRunningReleases) {
        this.maxRunningReleases = maxRunningReleases;
    }

    public int getMaxWorkflowExecutions() {
        return maxWorkflowExecutions;
    }

    public void setMaxWorkflowExecutions(final int maxWorkflowExecutions) {
        this.maxWorkflowExecutions = maxWorkflowExecutions;
    }

    public int getMaxWorkflowTemplates() {
        return maxWorkflowTemplates;
    }

    public void setMaxWorkflowTemplates(final int maxWorkflowTemplates) {
        this.maxWorkflowTemplates = maxWorkflowTemplates;
    }

    public int getMaxFolders() {
        return maxFolders;
    }

    public void setMaxFolders(final int maxFolders) {
        this.maxFolders = maxFolders;
    }

    public int getMaxConnections() {
        return maxConnections;
    }

    public void setMaxConnections(final int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxTemplates() {
        return maxTemplates;
    }

    public void setMaxTemplates(final int maxTemplates) {
        this.maxTemplates = maxTemplates;
    }

    public int getMaxTriggers() {
        return maxTriggers;
    }

    public void setMaxTriggers(final int maxTriggers) {
        this.maxTriggers = maxTriggers;
    }

    public int getMaxPatterns() {
        return maxPatterns;
    }

    public void setMaxPatterns(final int maxPatterns) {
        this.maxPatterns = maxPatterns;
    }

    public int getMaxDeliveries() {
        return maxDeliveries;
    }

    public void setMaxDeliveries(final int maxDeliveries) {
        this.maxDeliveries = maxDeliveries;
    }

    public int getMaxWorkflowPhases() {
        return maxWorkflowPhases;
    }

    public void setMaxWorkflowPhases(final int maxWorkflowPhases) {
        this.maxWorkflowPhases = maxWorkflowPhases;
    }

    public int getMaxWorkflowTasks() {
        return maxWorkflowTasks;
    }

    public void setMaxWorkflowTasks(final int maxWorkflowTasks) {
        this.maxWorkflowTasks = maxWorkflowTasks;
    }

    public int getMaxWorkflowExecutionPhases() {
        return maxWorkflowExecutionPhases;
    }

    public void setMaxWorkflowExecutionPhases(final int maxWorkflowExecutionPhases) {
        this.maxWorkflowExecutionPhases = maxWorkflowExecutionPhases;
    }

    public int getMaxWorkflowExecutionTasks() {
        return maxWorkflowExecutionTasks;
    }

    public void setMaxWorkflowExecutionTasks(final int maxWorkflowExecutionTasks) {
        this.maxWorkflowExecutionTasks = maxWorkflowExecutionTasks;
    }

    public int getMaxTemplatePhases() {
        return maxTemplatePhases;
    }

    public void setMaxTemplatePhases(final int maxTemplatePhases) {
        this.maxTemplatePhases = maxTemplatePhases;
    }

    public int getMaxTemplateTasks() {
        return maxTemplateTasks;
    }

    public void setMaxTemplateTasks(final int maxTemplateTasks) {
        this.maxTemplateTasks = maxTemplateTasks;
    }

    public int getMaxReleasePhases() {
        return maxReleasePhases;
    }

    public void setMaxReleasePhases(final int maxReleasePhases) {
        this.maxReleasePhases = maxReleasePhases;
    }

    public int getMaxReleaseTasks() {
        return maxReleaseTasks;
    }

    public void setMaxReleaseTasks(final int maxReleaseTasks) {
        this.maxReleaseTasks = maxReleaseTasks;
    }
}
