package com.xebialabs.xlrelease.domain.folder;

import java.util.*;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.internal.InternalMetadata;
import com.xebialabs.xlrelease.domain.CiWithInternalMetadata;
import com.xebialabs.xlrelease.domain.TenantAwareCi;
import com.xebialabs.xlrelease.domain.VariableContainer;
import com.xebialabs.xlrelease.domain.variables.FolderVariables;
import com.xebialabs.xlrelease.domain.variables.Variable;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.APPLICATIONS;
import static com.xebialabs.xlrelease.domain.variables.FolderVariables.FOLDER_VARIABLES;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(root = APPLICATIONS, versioned = false, description = "A grouping of releases and templates with own configuration")
public class Folder extends Directory implements CiWithInternalMetadata, VariableContainer, TenantAwareCi {
    public static String ROOT_FOLDER_ID = APPLICATIONS.getRootNodeName();

    @Property(description = "User provided title of the folder")
    protected String title;

    @Property(asContainment = true, description = "Sub-folders of this folder", required = false)
    protected Set<Folder> children = new HashSet<>();

    private Map<String, InternalMetadata> $metadata = new LinkedHashMap<>();

    private String tenantId;

    ///

    @PublicApiMember
    public String getTitle() {
        return title;
    }

    @PublicApiMember
    public void setTitle(final String title) {
        this.title = title;
    }

    public Set<Folder> getChildren() {
        return children;
    }

    public void setChildren(final Set<Folder> children) {
        this.children = new HashSet<>(children == null ? Collections.emptySet() : children);
    }

    @Override
    public Map<String, InternalMetadata> get$metadata() {
        return $metadata;
    }

    @Override
    public List<Variable> getAllVariables() {
        if (getFolderVariables() != null) {
            return new ArrayList<>(getFolderVariables().getVariables());
        }
        return Collections.emptyList();
    }

    public FolderVariables getFolderVariables() {
        return (FolderVariables) $metadata.get(FOLDER_VARIABLES);
    }

    public void setFolderVariables(FolderVariables folderVariables) {
        this.$metadata.put(FOLDER_VARIABLES, folderVariables);
    }

    @Override
    public String getTenantId() {
        return tenantId;
    }

    @Override
    public void setTenantId(final String tenantId) {
        this.tenantId = tenantId;
    }
}
