package com.xebialabs.xlrelease.domain.delivery

import com.xebialabs.xlrelease.domain.delivery.SubscriptionStatus._

import scala.beans.BeanProperty

case class SubscriptionResult(@BeanProperty status: SubscriptionStatus,
                              @BeanProperty message: String)

object SubscriptionResult {
  def completed(message: String): SubscriptionResult = SubscriptionResult(COMPLETED, message)

  def failed(message: String): SubscriptionResult = SubscriptionResult(FAILED, message)

  def inProgress(message: String = ""): SubscriptionResult = SubscriptionResult(IN_PROGRESS, message)
}