package com.xebialabs.xlrelease.domain.environments;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.serialization.json.jackson.CiSerializer;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(
        description = "Composite entity that combines ApplicationSource and DeploymentTarget making it a Deployment. Live deployment tracks deployment status changes.",
        versioned = false,
        root = Metadata.ConfigurationItemRoot.CONFIGURATION
)
@JsonSerialize(using = CiSerializer.class)
public class LiveDeployment extends BaseConfiguration {

    @Property(description = "Live deployment event source reference")
    private String eventSourceId;

    @Property(description = "Application associated with deployment")
    private Application application;

    @Property(description = "Environment associated with deployment")
    private Environment environment;

    @Property(description = "Current state of deployment", nested = true)
    @JsonSerialize(using = CiSerializer.class)
    private DeploymentState deploymentState;

    public static LiveDeployment create(
            String folderId, String eventSourceId,
            Application application, Environment environment,
            DeploymentState state
    ) {
        var liveDeployment = new LiveDeployment();
        liveDeployment.setId(null);
        liveDeployment.setFolderId(folderId);
        liveDeployment.setEventSourceId(eventSourceId);
        liveDeployment.setApplication(application);
        liveDeployment.setEnvironment(environment);
        liveDeployment.setDeploymentState(state);
        return liveDeployment;
    }

    public String getEventSourceId() {
        return eventSourceId;
    }

    public void setEventSourceId(String eventSourceId) {
        this.eventSourceId = eventSourceId;
    }

    public Application getApplication() {
        return application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Environment getEnvironment() {
        return environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public DeploymentState getDeploymentState() {
        return deploymentState;
    }

    public void setDeploymentState(DeploymentState deploymentState) {
        this.deploymentState = deploymentState;
    }
}
