package com.xebialabs.xlrelease.domain.events

import com.xebialabs.xlrelease.domain.TemplateLogo

/**
 * Common interface for domain events related to template logo modification.
 */
sealed trait TemplateLogoEvent extends XLReleaseEvent

/**
 * Event published when a template logo is updated.
 *
 * @param templateId   the ID of the template in which the logo was created.
 * @param templateLogo the created template logo.
 */
case class TemplateLogoUpdatedEvent(templateId: String, templateLogo: TemplateLogo) extends TemplateLogoEvent

