package com.xebialabs.xlrelease.domain.events

import com.xebialabs.xlrelease.configuration.TenantLimit
import com.xebialabs.xlrelease.domain.Tenant

// tenant events
sealed trait TenantEvent extends XLReleaseEvent

case class TenantCreatedEvent(tenant: Tenant) extends TenantEvent

case class TenantUpdatedEvent(original: Tenant, updated: Tenant) extends TenantEvent

case class TenantDeletedEvent(tenant: Tenant) extends TenantEvent

sealed trait TenantLinkUpdatedEvent extends TenantEvent

case class FolderTenantLinkEvent(tenantId: String, folderIds: Seq[String]) extends TenantLinkUpdatedEvent

case class UserProfileTenantLinkEvent(tenantId: String, userProfileIds: Seq[String]) extends TenantLinkUpdatedEvent

// tenant limit events
sealed trait TenantLimitEvent extends XLReleaseEvent

case class TenantLimitCreatedEvent(tenantLimit: TenantLimit) extends TenantLimitEvent

case class TenantLimitUpdatedEvent(original: TenantLimit, updated: TenantLimit) extends TenantLimitEvent

case class TenantLimitDeletedEvent(tenantLimit: TenantLimit) extends TenantLimitEvent
