package com.xebialabs.xlrelease.domain.recover;

import java.util.Arrays;

import com.xebialabs.xlplatform.documentation.PublicApiRef;

@PublicApiRef
public enum TaskRecoverOp {
    SKIP_TASK("Skip task"),
    RESTART_PHASE("Restart phase"),
    RUN_SCRIPT("Run script");

    private final String label;

    TaskRecoverOp(String label) {
        this.label = label;
    }

    public String getLabel() {
        return label;
    }

    public static TaskRecoverOp fromLabel(String label) {
        return Arrays.stream(values())
                .filter(op -> op.label.equalsIgnoreCase(label))
                .findFirst()
                .orElseThrow(() -> new IllegalArgumentException("Unsupported task recover operation"));
    }
}

