package com.xebialabs.xlrelease.risk.domain.riskassessors;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;

import static java.lang.String.format;

@PublicApiRef
@Metadata(label = "ReleaseStatusFailingRiskAssessor", versioned = false)
public class ReleaseStatusFailingRiskAssessor extends RiskAssessor {

    private static final String RELEASE_FAILING_HEADLINE = "Release is failing";

    @Override
    public RiskAssessment execute(final Release release, final RiskProfile riskProfile) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());

        List<String> messages = new ArrayList<>();
        if (release.isFailing()) {
            assessment.setScore(riskProfile.getValueFor(getType()));
            assessment.setHeadline(RELEASE_FAILING_HEADLINE);
            messages.add(format("%s is failing", release.getTitle()));
        }
        else {
            assessment.setScore(OK_SCORE);
            assessment.setHeadline(OK_HEADLINE);
        }

        assessment.setMessages(messages);
        return assessment;
    }
}
