package com.xebialabs.xlrelease.domain;

import java.util.Arrays;
import org.springframework.util.StringUtils;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
public enum ReleaseKind {
    RELEASE("release"),
    WORKFLOW("workflow");

    private final String value;

    ReleaseKind(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static ReleaseKind fromString(String kind) {
        try {
            if (StringUtils.hasText(kind)) {
                return ReleaseKind.valueOf(kind.toUpperCase());
            }
            throw new IllegalArgumentException("Kind value cannot be null or empty");
        } catch (IllegalArgumentException e) {
            String validKinds = Arrays.toString(ReleaseKind.values());
            throw new IllegalArgumentException("Invalid kind value: " + kind + ". Allowed values for the 'kind' parameter are: " + validKinds);
        }
    }
}
