package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.utils.WordUtils;

import static com.xebialabs.deployit.booter.local.utils.Strings.deCamelize;

public class TaskDefinition {

    public static final String XLRELEASE_GROUP_REPLACEMENT = "Core";
    public static final String XLRELEASE_GROUP = "xlrelease";
    public static final String XEBIALABS_GROUP = "xebialabs";
    protected String typeName;
    protected String displayGroup;
    protected String displayName;
    protected String description;
    protected String iconLocation;
    protected String documentationPage;
    protected boolean allowed;
    protected boolean supportedInWorkflow;
    protected boolean containerTask = false;

    public TaskDefinition(Type type, boolean allowed) {
        this.typeName = type.toString();

        this.displayGroup = getDisplayGroup(type);
        this.displayName = getDisplayName(type);
        Descriptor descriptor = type.getDescriptor();
        this.description = descriptor.getDescription();
        this.allowed = allowed;
        this.supportedInWorkflow = getSupportedInWorkflow(type);
        this.iconLocation = getIconLocation(descriptor);
        this.documentationPage = getDocumentationPage(descriptor);
    }

    public static String getDisplayGroup(Type type) {
        String prefix = getPrefix(type);
        return isCore(prefix) ? XLRELEASE_GROUP_REPLACEMENT : prefix;
    }

    public static String getDisplayName(Type type) {
        String label = type.getDescriptor().getLabel();

        // When label annotation is missing, the type system prefix it with the group, this is not what we want
        String groupPrefix = getPrefix(type) + ": ";
        if (label.startsWith(groupPrefix)) {
            label = label.replace(groupPrefix, "");
        }

        return label;
    }

    public static boolean getSupportedInWorkflow(Type type) {
        return (boolean) type.getDescriptor().getPropertyDescriptor("supportedInWorkflow").getDefaultValue();
    }

    public static String getIconLocation(Descriptor descriptor) {
        return getPropertyDescriptorDefaultValue(descriptor, "iconLocation");
    }

    public static String getDocumentationPage(Descriptor descriptor) {
        return getPropertyDescriptorDefaultValue(descriptor, "documentationPage");
    }

    public String getTypeName() {
        return typeName;
    }

    public String getDisplayGroup() {
        return displayGroup;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getDescription() {
        return description;
    }

    public String getIconLocation() {
        return iconLocation;
    }

    public String getDocumentationPage() {
        return documentationPage;
    }

    public boolean isAllowed() {
        return allowed;
    }

    public boolean isSupportedInWorkflow() {
        return supportedInWorkflow;
    }

    public boolean isContainerTaskDefinition() {
        return containerTask;
    }

    protected static String getPrefix(Type type) {
        if (type.getDescriptor().getLabel().contains(":")) {
            return type.getDescriptor().getLabel().split(":")[0];
        } else if (isCore(type.getPrefix())) {
            return type.getPrefix();
        } else {
            return WordUtils.capitalize(deCamelize(type.getPrefix()).toLowerCase());
        }
    }

    protected static boolean isCore(final String prefix) {
        return prefix.equalsIgnoreCase(XLRELEASE_GROUP) || prefix.equalsIgnoreCase(XEBIALABS_GROUP);
    }

    private static String getPropertyDescriptorDefaultValue(Descriptor descriptor, String property) {
        PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(property);
        if (propertyDescriptor == null) {
            return "";
        }
        if (propertyDescriptor.getDefaultValue() == null) {
            return "";
        }
        return propertyDescriptor.getDefaultValue().toString();
    }
}
