package com.xebialabs.xlrelease.domain.configuration;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

import java.util.HashSet;
import java.util.Set;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, virtual = true, versioned = false)
public class ContainerHttpConnection extends HttpConnection {

    @Property(label = "Capabilities", description = "Route jobs to particular types of remote runners based on capabilities", defaultValue = "remote")
    private Set<String> capabilities = new HashSet<>();

    @PublicApiMember
    public Set<String> getCapabilities() {
        return capabilities;
    }

    @PublicApiMember
    public void setCapabilities(final Set<String> capabilities) {
        this.capabilities = capabilities;
    }
}
