package com.xebialabs.xlrelease.domain.group;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;

@PublicApiRef
@ShowOnlyPublicApiMembers
public enum ReleaseGroupStatus {
    PLANNED("planned"),
    IN_PROGRESS("in_progress"),
    PAUSED("paused"),
    FAILING("failing"),
    FAILED("failed"),
    COMPLETED("completed"),
    ABORTED("aborted");

    private final String value;

    public static final ReleaseGroupStatus[] INACTIVE_STATUSES = new ReleaseGroupStatus[]{COMPLETED, ABORTED};

    ReleaseGroupStatus(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static ReleaseGroupStatus fromRelease(ReleaseStatus status) {
        if (status == ReleaseStatus.TEMPLATE) {
            return PLANNED;
        } else {
            return ReleaseGroupStatus.valueOf(status.name());
        }
    }
}
