package com.xebialabs.xlrelease.domain.status;

import java.util.Arrays;
import org.springframework.util.StringUtils;

public enum TenantStatus {
    ACTIVE("active"),
    SUSPENDED("suspended"),
    DISABLED("disabled");

    private final String value;

    TenantStatus(String value) {
        this.value = value;
    }

    public String value() {
        return value;
    }

    public static TenantStatus fromString(String tenantStatus) {
        try {
            if (StringUtils.hasText(tenantStatus)) {
                return TenantStatus.valueOf(tenantStatus.toUpperCase());
            }
            throw new IllegalArgumentException("tenantStatus cannot be null or empty");
        } catch (IllegalArgumentException e) {
            String validStatues = Arrays.toString(TenantStatus.values());
            throw new IllegalArgumentException("Invalid tenantStatus value: " + tenantStatus + ". Allowed values for the 'tenantStatus' parameter are: " + validStatues);
        }
    }
}
