package com.xebialabs.xlrelease.domain.variables;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.variable.VariableHelper;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class StringVariable extends Variable.VariableWithValue<String> {

    @PublicApiMember
    @Property(required = false, description = "Value of the release variable or default value of the template variable")
    protected String value;

    @PublicApiMember
    @Property(required = false, defaultValue = "false", description = "If checked variable value will be multiline text ")
    protected boolean multiline;

    @PublicApiMember
    @Property(required = false, description = "Set this to true if you don't want the contents of this variable scanned for other variables and updated after the variables are resolved.")
    protected boolean preventInterpolation;

    @PublicApiMember
    @Override
    public String getValue() {
        return value;
    }

    @PublicApiMember
    public boolean getMultiline() {
        return multiline;
    }

    @PublicApiMember
    public void setMultiline(final boolean multiline) {
        this.multiline = multiline;
    }

    @Override
    public String getEmptyValue() {
        return "";
    }

    @PublicApiMember
    @Override
    public void setValue(final String value) {
        this.value = value;
    }

    @Override
    public void setUntypedValue(Object newValue) {
        this.setValue(newValue != null ? VariableHelper.toString(newValue) : null);
    }

    @Override
    public boolean isPassword() {
        return false;
    }

    public String getValueAsString() {
        return formatValueAsString(getValue());
    }

    public String getEmptyValueAsString() {
        return formatValueAsString(getEmptyValue());
    }

    @Override
    public boolean isValueAssignableFrom(final Object value) {
        return value instanceof String;
    }

    private String formatValueAsString(Object valueToFormat) {
        return (valueToFormat == null) ? getEmptyValue() : String.valueOf(valueToFormat);
    }

    @PublicApiMember
    public boolean isPreventInterpolation() {
        return preventInterpolation;
    }

    @PublicApiMember
    public void setPreventInterpolation(boolean preventInterpolation) {
        this.preventInterpolation = preventInterpolation;
    }
}
