package com.xebialabs.xlrelease.domain

import com.fasterxml.jackson.annotation.{JsonFormat, JsonProperty}

import java.time.Instant
import scala.beans.BeanProperty

case class Datacenter(@BeanProperty title: String,
                      @BeanProperty targetState: DatacenterTargetState,
                      @BeanProperty updatedBy: String,
                      @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone = "UTC")
                      @BeanProperty updatedDate: Instant) {
  @JsonProperty("updatedBy")
  def getUpdatedByForApiResponse: String = Option(updatedBy).getOrElse("system")
}
