package com.xebialabs.xlrelease.domain

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlplatform.documentation.PublicApiRef
import com.xebialabs.xlrelease.domain.JdbcExportHook.JdbcExportHookException

import java.sql.{Connection, DriverManager}
import scala.util.{Failure, Success, Try}

object JdbcExportHook {

  class JdbcExportHookException(message: String, cause: Throwable) extends RuntimeException(message, cause)

}

@PublicApiRef
@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, versioned = false, virtual = true)
class JdbcExportHook extends ExportHook {

  @Property(required = true, description="JDBC URL which should always begin with the 'jdbc:' protocol")
  var url: String = _

  @Property(required = false)
  var username: String = _

  @Property(required = false, password = true)
  var password: String = _

  /**
   * Constructs and returns a connection object which can be used for accessing the database defined within current JDBC export hook. This method neither opens nor closes the connection.
   */
  def getJdbcConnection: Connection = {
    Try {
      DriverManager.getConnection(url, username, password)
    } match {
      case Success(connection) => connection
      case Failure(e: Throwable) => throw new JdbcExportHookException(s"Could not create connection for JDBC export hook $getTitle", e)
    }
  }

}
