package com.xebialabs.xlrelease.domain

import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.repository.Ids.SEPARATOR

import scala.beans.BeanProperty

object OriginTemplateData {
  val ORIGIN_TEMPLATE_METADATA_PREFIX = "template"

  def apply(releaseId: String, templateId: String, templateTitle: String): OriginTemplateData = {
    val originTemplateData = new OriginTemplateData(templateId, templateTitle)
    originTemplateData.setId(releaseId + SEPARATOR + ORIGIN_TEMPLATE_METADATA_PREFIX)
    originTemplateData
  }
}

@Metadata(versioned = false, description = "Summary of release progress")
class OriginTemplateData(@Property @BeanProperty var originTemplateId: String,
                          @Property @BeanProperty var originTemplateTitle: String) extends ReleaseExtension {
  def this() = this(null, null)
}
