package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;

public abstract class ResolvableScriptTask extends BaseScriptTask implements ScriptVariableInterpolation {

    @Property(hidden = true, isTransient = true, order = Integer.MAX_VALUE, label = "Script timeout", category = "internal", description = "Maximum execution time (in seconds) allowed for each individual script", defaultValue = "-1")
    private int scriptTimeout;

    @Property
    boolean ignoreScriptVariableInterpolation;

    public abstract String getScript();

    @PublicApiMember
    @Override
    public boolean isScriptInterpolationOff() {
        return ignoreScriptVariableInterpolation;
    }

    @PublicApiMember
    public void setIgnoreScriptVariableInterpolation(final boolean ignoreScriptVariableInterpolation) {
        this.ignoreScriptVariableInterpolation = ignoreScriptVariableInterpolation;
    }

    public int getScriptTimeout() {
        return scriptTimeout;
    }

    public void setScriptTimeout(int scriptTimeout) {
        this.scriptTimeout = scriptTimeout;
    }
}
