package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned = false)
public class TemplateLogo extends BaseArtifact {
    public static final String EXPORT_DIRECTORY = "template-logo";

    @Property(hidden = true, category = "internal", description = "Maximum size of a logo. Default value is 1MB.", defaultValue = "1")
    private int maxLogoSize;

    public TemplateLogo() {
        super();
    }

    public TemplateLogo(OverthereFile file, String contentType) {
        super(file, contentType);
    }

    @Override
    public String getExportDirectoryName() {
        return EXPORT_DIRECTORY;
    }

    public int getMaxLogoSize() {
        return maxLogoSize;
    }

    public void setMaxLogoSize(final int maxLogoSize) {
        this.maxLogoSize = maxLogoSize;
    }

    public static int getDefaultMaxLogoSize() {
        return (int) Type.valueOf(TemplateLogo.class).getDescriptor().getPropertyDescriptor("maxLogoSize").getDefaultValue();
    }
}
