package com.xebialabs.xlrelease.domain;


import java.util.Date;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;

/**
 * No setters defined, because user profiles may be cached.
 */
@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, versioned = false)
public class UserProfile extends BaseConfigurationItem {

    /**
     * Lowercase version of the id in order to avoid duplication
     */
    @Property(required = false)
    private String canonicalId;

    @Property
    private String email;

    @Property
    private String fullName;

    @Property(required = false, description = "ExternalId used on the UI to represent extra attribute for user from external authentication provider")
    private String externalId;

    @Property(required = false, description = "ID of the tenant this user belongs to")
    private String tenantId;

    @Property(required = false)
    private boolean loginAllowed;

    @Property(required = false, description = "Date format used on the UI to represent short dates, e.g. M/d/yy (4/13/17)")
    private String dateFormat;

    @Property(required = false, description = "Time format used on the UI to represent short times, e.g. h:mm a (1:54 PM)")
    private String timeFormat;

    @Property(required = false, defaultValue = "0", description = "Specifies the first day of week to be used in the calendar and the date pickers, e.g. -1 - Browser setting, 0 - Sunday, 1 - Monday etc.")
    private Integer firstDayOfWeek;

    @Property(required = false, description = "Last time the system saw this user")
    private Date lastActive;

    @Property(required = false, defaultValue = "true", description = "Opt-out from anonymous product usage analytics")
    private boolean analyticsEnabled = true;

    public UserProfile() {
    }

    public UserProfile(String id) {
        setId(id);
        this.canonicalId = getName().toLowerCase();
    }

    public UserProfile(String id, String email, String fullName, boolean loginAllowed) {
        this(id);
        this.email = email;
        this.fullName = fullName;
        this.loginAllowed = loginAllowed;
        this.lastActive = new Date();
    }

    public UserProfile(String id, String email, String fullName, boolean loginAllowed, String externalId) {
        this(id, email, fullName, loginAllowed);
        this.externalId = externalId;
    }

    public UserProfile(String id, String email, String fullName, boolean loginAllowed, Date lastActive) {
        this(id);
        this.email = email;
        this.fullName = fullName;
        this.loginAllowed = loginAllowed;
        this.lastActive = lastActive;
    }

    public UserProfile(String id, String email, String fullName, boolean loginAllowed, Date lastActive, String externalId) {
        this(id, email, fullName, loginAllowed, lastActive);
        this.externalId = externalId;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getCanonicalId() {
        return canonicalId;
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getExternalId() {
        return externalId;
    }

    public void setExternalId(final String externalId) {
        this.externalId = externalId;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean isLoginAllowed() {
        return loginAllowed;
    }

    public void setLoginAllowed(boolean loginAllowed) {
        this.loginAllowed = loginAllowed;
    }

    public String getDateFormat() {
        return dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getTimeFormat() {
        return timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public Integer getFirstDayOfWeek() {
        return firstDayOfWeek;
    }

    public void setFirstDayOfWeek(final Integer firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    public Date getLastActive() {
        return lastActive;
    }

    public void setLastActive(Date lastActive) {
        this.lastActive = lastActive;
    }

    public boolean isAnalyticsEnabled() {
        return analyticsEnabled;
    }

    public void setAnalyticsEnabled(boolean analyticsEnabled) {
        this.analyticsEnabled = analyticsEnabled;
    }

}
