package com.xebialabs.xlrelease.domain.calendar;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import static com.google.common.base.Strings.isNullOrEmpty;

@Metadata(description = "A special day in the calendar", root = Metadata.ConfigurationItemRoot.CONFIGURATION, versioned = false)
public class SpecialDay extends CalendarEntry {
    public static final String DATE_FORMAT = "yyyyMMdd";

    @Property(description = "The color used to mark the day in the calendar.")
    private String color;

    public SpecialDay() {
        this("", "");
    }

    public SpecialDay(String label, String color) {
        setLabel(label);
        this.color = color;
    }

    public boolean isBlank() {
        return isNullOrEmpty(label) && isNullOrEmpty(color);
    }

    public String getColor() {
        return color;
    }

    public void setColor(final String color) {
        this.color = color;
    }
}
