package com.xebialabs.xlrelease.domain.delivery

import com.xebialabs.deployit.plugin.api.udm.Property
import com.xebialabs.xlrelease.domain.delivery.SubscriptionResult.{completed, inProgress}

import scala.beans.BeanProperty

class StageCompletionSubscriber extends Subscriber {

  @BeanProperty
  @Property
  var stageId: String = _

  override def validate(delivery: Delivery): Unit = {
    delivery.getStageByIdOrTitle(this.stageId)
  }

  override def evaluate(delivery: Delivery): SubscriptionResult = {
    val stage = delivery.getStageByIdOrTitle(stageId)
    if (stage.getStatus == StageStatus.CLOSED) {
      completed(s"Stage '${stage.getTitle}' is already completed\n")
    } else {
      inProgress()
    }
  }
}
