package com.xebialabs.xlrelease.domain.distributed.events

/**
 * Common interface for domain events related to comments modification.
 */
sealed trait DistributedCommentEvent extends DistributedXLReleaseEvent {
  def taskId: String
}

/**
 * Event published when a comment is created on a task.
 * @param taskId the identifier of the task with the changed comment
 * @param commentId the identifier of the comment that was created
 */
case class DistributedCommentCreatedEvent(taskId: String, commentId: String) extends DistributedCommentEvent

/**
 * Event published when a comment is updated on a task.
 * @param taskId the identifier of the task with the changed comment
 * @param commentId the identifier of the comment that was updated
 */
case class DistributedCommentUpdatedEvent(taskId: String, commentId: String) extends DistributedCommentEvent

/**
 * Event published when a comment is deleted on a task.
 * @param taskId the identifier of the task with the changed comment
 * @param commentId the identifier of the comment that was deleted
 */
case class DistributedCommentDeletedEvent(taskId: String, commentId: String) extends DistributedCommentEvent


