package com.xebialabs.xlrelease.domain.distributed.events

sealed trait DistributedConfigurationEvents extends DistributedXLReleaseEvent {
  def configurationType: String
  def configurationId: String
}

case class DistributedConfigurationCreatedEvent(configurationType: String, configurationId: String) extends DistributedConfigurationEvents

case class DistributedConfigurationUpdatedEvent(configurationType: String, configurationId: String) extends DistributedConfigurationEvents

case class DistributedConfigurationDeletedEvent(configurationType: String, configurationId: String) extends DistributedConfigurationEvents

case class DistributedConfigurationCopiedEvent(configurationType: String, configurationId: String, newConfigurationId: String)
  extends DistributedConfigurationEvents
