package com.xebialabs.xlrelease.domain.environments;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.TenantAwareCi;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(description = "Representation of an artifact that can be deployed to an environment.", versioned = false, root = Metadata.ConfigurationItemRoot.CONFIGURATION)
public class Application extends BaseConfiguration implements TenantAwareCi {
    @Property(description = "Name of the application")
    private String title;

    @Property(description = "External system Unique correlation ID for Application", readonly = true)
    private String correlationUid;

    @Property(required = false, nested = true)
    private ApplicationSource applicationSource;

    @Property(required = false, description = "Environments attached to this application")
    private List<Environment> environments = new ArrayList<>();

    //This has to be a release property as this CI is serialized many times before data insert
    @Property(required = false, description = "Tenant attached to this application", category = "internal", hidden = true)
    private String tenantId;

    @PublicApiMember
    public String getTitle() {
        return title;
    }

    @PublicApiMember
    public void setTitle(final String title) {
        this.title = title;
    }

    public String getCorrelationUid() {
        return correlationUid;
    }

    public void setCorrelationUid(String correlationUid) {
        this.correlationUid = correlationUid;
    }

    @PublicApiMember
    public List<Environment> getEnvironments() {
        return environments;
    }

    @PublicApiMember
    public void setEnvironments(final List<Environment> environments) {
        this.environments = environments;
    }

    public ApplicationSource getApplicationSource() {
        return applicationSource;
    }

    public void setApplicationSource(ApplicationSource applicationSource) {
        this.applicationSource = applicationSource;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(final String tenantId) {
        this.tenantId = tenantId;
    }
}
