package com.xebialabs.xlrelease.domain.events

import com.xebialabs.xlrelease.domain.DatacenterTargetState

sealed trait DatacenterEvent extends XLReleaseEvent

case class DatacenterCreatedEvent(datacenter: String, targetState: DatacenterTargetState) extends DatacenterEvent

case class DatacenterDeletedEvent(datacenter: String) extends DatacenterEvent

case class DatacenterUpdatedEvent(datacenter: String, previousTargetState: DatacenterTargetState, newTargetState: DatacenterTargetState) extends DatacenterEvent
