package com.xebialabs.xlrelease.domain.events

import com.xebialabs.xlrelease.domain.Dependency

/**
  * Common interface for domain events related to dependency modification.
  */
sealed trait DependencyEvent extends XLReleaseEvent

/**
  * Event published when a dependency is created in a gate task.
  * @param dependency the created dependency.
  */
case class DependencyCreatedEvent(dependency: Dependency) extends DependencyEvent

/**
  * Event published when a dependency is updated in a gate task.
  * @param original a copy of the original dependency.
  * @param updated updated dependency.
  */
case class DependencyUpdatedEvent(original: Dependency, updated: Dependency) extends DependencyEvent

/**
  * Event published when a dependency is deleted from a gate task.
  * @param dependency deleted dependency.
  */
case class DependencyDeletedEvent(dependency: Dependency) extends DependencyEvent
