package com.xebialabs.xlrelease.domain.events

import com.xebialabs.xlrelease.domain.facet.{Facet, TaskReportingRecord}

/**
  * Common interface for domain events related to facet modification.
  */
sealed trait FacetEvent extends XLReleaseEvent {
  val facet: Facet
}

/**
  * Event published when a facet is created.
  *
  * @param facet the created facet.
  */
case class FacetCreatedEvent(facet: Facet) extends FacetEvent

/**
  * Event published when a facet is updated.
  *
  * @param original a copy of the original facet.
  * @param facet    updated facet.
  */
case class FacetUpdatedEvent(original: Facet, facet: Facet) extends FacetEvent

/**
  * Event published when a facet is manually deleted.
  *
  * @param facet deleted facet.
  */
case class FacetDeletedEvent(facet: Facet) extends FacetEvent

/**
  * Event published when facet configuration is complete (facet is mapped to one or
  * many facets according to task attributes) and configured facets are saved
  * @param originalFacet the original facet that was submitted to FacetService (not configured yet)
  * @param configuredFacets the facets that were saved, thus configured facets
  * @param hasConfiguration true if facet was actually reconfigured (thus task has any configuration attributes)
  */
case class FacetConfiguredFacetsCreatedEvent(originalFacet: TaskReportingRecord,
                                             configuredFacets: java.util.List[TaskReportingRecord],
                                             hasConfiguration: Boolean) extends XLReleaseEvent
