package com.xebialabs.xlrelease.domain.management

import com.xebialabs.xlrelease.domain.management.ServiceState.{Running, ServiceState, Starting, Stopped, Stopping}

sealed trait ServiceStatus {
  def name: String

  def state: ServiceState
}

case class SimpleServiceStatus(name: String, state: ServiceState) extends ServiceStatus

case class CompositeServiceStatus(name: String, state: ServiceState, childServiceStatus: List[ServiceStatus]) extends ServiceStatus

object ServiceStatus {
  // scalastyle:off cyclomatic.complexity
  def computeState(currentState: ServiceState, childServiceStatus: List[ServiceStatus]): ServiceState = {
    val childStates = childServiceStatus.map(_.state)
    (currentState, childStates) match {
      case (Starting, states) if states.forall(_ == Running) => Running
      case (Running, states) if states.forall(_ == Running) => Running
      case (Running, states) if states.contains(Stopping) => Stopping
      case (Running, states) if states.forall(_ == Stopped) => Stopped
      case (Stopping, states) if states.forall(_ == Stopped) => Stopped
      case (Stopped, states) if states.forall(_ == Running) => Running
      case _ => currentState
    }
  }
  // scalastyle:on cyclomatic.complexity
}
