package com.xebialabs.xlrelease.domain.udm.reporting;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;

import static com.xebialabs.xlrelease.domain.Task.CATEGORY_INPUT;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label = "Deployment", description = "Unified Data Model for Deployment")
public class DeploymentRecord extends TaskReportingRecord {

    @Property(category = CATEGORY_INPUT, label = "Deployment task", description = "The deployment.")
    private String deploymentTask;

    @Property(category = CATEGORY_INPUT, label = "Deployment task URL", description = "The URL of the deployment.")
    private String deploymentTask_url;

    @Property(category = CATEGORY_INPUT, required = false, label = "Application", description = "The name of the application whose version is being deployed.")
    private String applicationName;

    @Property(category = CATEGORY_INPUT, required = false, label = "Application version", description = "The version of the application.")
    private String version;

    @Property(category = CATEGORY_INPUT, required = false, label = "Environment", description = "The name of the environment where this task deploys to.")
    private String environmentName;

    @Property(category = CATEGORY_INPUT, label = "Deployment status", description = "The status of the deployment.")
    private DeploymentStatus status;

    @PublicApiMember
    public String getDeploymentTask() {
        return deploymentTask;
    }

    @PublicApiMember
    public void setDeploymentTask(final String deploymentTask) {
        this.deploymentTask = deploymentTask;
    }

    @PublicApiMember
    public String getDeploymentTask_url() {
        return deploymentTask_url;
    }

    @PublicApiMember
    public void setDeploymentTask_url(final String deploymentTask_url) {
        this.deploymentTask_url = deploymentTask_url;
    }

    @PublicApiMember
    public String getApplicationName() {
        return applicationName;
    }

    @PublicApiMember
    public void setApplicationName(final String applicationName) {
        this.applicationName = applicationName;
    }

    @PublicApiMember
    public String getVersion() {
        return version;
    }

    @PublicApiMember
    public void setVersion(final String version) {
        this.version = version;
    }

    @PublicApiMember
    public String getEnvironmentName() {
        return environmentName;
    }

    @PublicApiMember
    public void setEnvironmentName(final String environmentName) {
        this.environmentName = environmentName;
    }

    @PublicApiMember
    public DeploymentStatus getStatus() {
        return status;
    }

    @PublicApiMember
    public void setStatus(final DeploymentStatus status) {
        this.status = status;
    }

}
