package com.xebialabs.xlrelease.domain.udm.reporting;

import java.util.Date;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;

import static com.xebialabs.xlrelease.domain.Task.CATEGORY_INPUT;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label = "Plan", description = "Unified Data Model for Plan")
public class PlanRecord extends TaskReportingRecord {

    @Property(category = CATEGORY_INPUT, label = "Ticket id", description = "Ticket ID.")
    private String ticket;

    @Property(category = CATEGORY_INPUT, label = "Title", description = "Issue title.")
    private String title;

    @Property(category = CATEGORY_INPUT, label = "Ticket type", description = "Ticket type.")
    private String ticketType;

    @Property(category = CATEGORY_INPUT, label = "Status", description = "Status of the ticket.")
    private String status;

    @Property(category = CATEGORY_INPUT, label = "Updated on", description = "Date and time of last update.")
    private Date updatedDate;

    @Property(category = CATEGORY_INPUT, label = "Updated by", description = "Person who performed the last update." , required = false)
    private String updatedBy;

    @Property(category = CATEGORY_INPUT, label = "Ticket URL", description = "Link to the ticket.")
    private String ticket_url;

    @PublicApiMember
    public String getTicket() {
        return ticket;
    }

    @PublicApiMember
    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    @PublicApiMember
    public String getTitle() {
        return title;
    }

    @PublicApiMember
    public void setTitle(String title) {
        this.title = title;
    }

    @PublicApiMember
    public String getTicketType() {
        return ticketType;
    }

    @PublicApiMember
    public void setTicketType(String ticketType) {
        this.ticketType = ticketType;
    }

    @PublicApiMember
    public String getStatus() {
        return status;
    }

    @PublicApiMember
    public void setStatus(String status) {
        this.status = status;
    }

    @PublicApiMember
    public Date getUpdatedDate() {
        return updatedDate;
    }

    @PublicApiMember
    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    @PublicApiMember
    public String getUpdatedBy() {
        return updatedBy;
    }

    @PublicApiMember
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    @PublicApiMember
    public String getTicket_url() {
        return ticket_url;
    }

    @PublicApiMember
    public void setTicket_url(String ticket_url) {
        this.ticket_url = ticket_url;
    }

}
