package com.xebialabs.xlrelease.domain.variables;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

import static java.lang.String.format;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class BooleanVariable extends Variable.VariableWithValue<Boolean> {

    @PublicApiMember
    @Property(required = false, description = "Value of the release variable or default value of the template variable")
    protected boolean value;

    @PublicApiMember
    @Override
    public Boolean getValue() {
        return value;
    }

    @Override
    public Boolean getEmptyValue() {
        return false;
    }

    @Override
    public boolean isValueEmpty() {
        return false;
    }

    @PublicApiMember
    @Override
    public void setValue(final Boolean value) {
        this.value = value;
    }

    @Override
    public void setUntypedValue(Object newValue) {
        if (newValue instanceof Boolean) {
            this.setValue((Boolean) newValue);
        } else if (newValue instanceof String) {
            String newValueString = (String) newValue;
            if (newValueString.equalsIgnoreCase("true") || newValueString.equalsIgnoreCase("false")) {
                this.setValue(Boolean.valueOf(newValueString));
            } else {
                throw new IllegalArgumentException(format("Cannot set instance of %s into boolean variable value: %s", newValue.getClass().getSimpleName(), newValue));
            }
        } else if (newValue == null) {
            this.setValue(this.getEmptyValue());
        } else {
            throw new IllegalArgumentException(format("Cannot set instance of %s into boolean variable value: %s", newValue.getClass().getSimpleName(), newValue));
        }
    }

    @Override
    public boolean isPassword() {
        return false;
    }

    @Override
    public String getValueAsString() {
        return value ? "True" : "False";
    }

    @Override
    public String getEmptyValueAsString() {
        return "False";
    }

    @Override
    public boolean isValueAssignableFrom(Object value) {
        return (value instanceof Boolean);
    }
}