package com.xebialabs.xlrelease.risk.domain.riskassessors;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;

import static java.lang.String.format;
import static java.util.Optional.ofNullable;

@PublicApiRef
@Metadata(label = "ReleaseFlaggedAtRiskAssessor", versioned = false)
public class ReleaseFlaggedAtRiskAssessor extends RiskAssessor {

    private static final String RELEASE_AT_RISK_HEADLINE = "Release is flagged as red";
    private static final String RELEASE_FLAGGED_MESSAGE = "%s: %s";

    @Override
    public RiskAssessment execute(final Release release, final RiskProfile riskProfile) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());

        List<String> messages = new ArrayList<>();

        if (release.getFlagStatus() == FlagStatus.AT_RISK) {
            assessment.setScore(riskProfile.getValueFor(getType()));
            assessment.setHeadline(RELEASE_AT_RISK_HEADLINE);
            messages.add(getMessage(release.getTitle(), release.getFlagComment()));
        } else {
            assessment.setScore(OK_SCORE);
            assessment.setHeadline(OK_HEADLINE);
        }

        assessment.setMessages(messages);
        return assessment;
    }

    private String getMessage(String releaseTitle, String flagComment) {
        return format(RELEASE_FLAGGED_MESSAGE, releaseTitle, ofNullable(flagComment).orElse(""));
    }


}
