package com.xebialabs.xlrelease.risk.domain.riskassessors;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;

import static java.lang.String.format;
import static java.util.Optional.ofNullable;

abstract public class TaskFlagRiskAssessor extends RiskAssessor {

    @Property(description = "Minimum amount of flags to have to score")
    protected int minFlags;

    @Property(description = "Maximum amount of flags to have to score")
    protected int maxFlags;

    protected RiskAssessment executeForFlag(final RiskAssessment assessment, final Release release, RiskProfile riskProfile, FlagStatus flagStatus, String flaggedHeadline) {
        List<Task> flaggedTasks = release
                .getAllTasks()
                .stream()
                .filter(t -> flagStatus == t.getFlagStatus())
                .collect(Collectors.toList());

        List<String> messages = new ArrayList<>();
        int numberOfFlaggedTasks = flaggedTasks.size();
        if (numberOfFlaggedTasks == 0) {
            assessment.setScore(OK_SCORE);
            assessment.setHeadline(OK_HEADLINE);
        } else {
            int score = getScore(numberOfFlaggedTasks, riskProfile);
            if (score != OK_SCORE) {
                assessment.setHeadline(flaggedHeadline);
                flaggedTasks.forEach(t -> messages.add(format("%s: %s", t.getTitle(), ofNullable(t.getFlagComment()).orElse(""))));
                assessment.setScore(getScore(numberOfFlaggedTasks, riskProfile));
            } else {
                assessment.setScore(OK_SCORE);
                assessment.setHeadline(OK_HEADLINE);
            }
        }
        assessment.setMessages(messages);

        return assessment;
    }

    protected abstract int getScore(int numberOfFlaggedTasks, RiskProfile riskProfile);

    public int getMinFlags() {
        return minFlags;
    }

    public void setMinFlags(final int minFlags) {
        this.minFlags = minFlags;
    }

    public int getMaxFlags() {
        return maxFlags;
    }

    public void setMaxFlags(final int maxFlags) {
        this.maxFlags = maxFlags;
    }
}
