package com.xebialabs.xlrelease.risk.domain.riskassessors;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.risk.domain.RiskAssessment;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;

@Metadata(versioned = false, virtual = true)
public class TaskWithXFlagsNeedsAttentionRiskAssessor extends TaskFlagRiskAssessor {

    public static final String TASKS_NEED_ATTENTION_HEADLINE = "Release has tasks flagged as amber";

    @Override
    protected int getScore(final int numberOfFlaggedTasks, final RiskProfile riskProfile) {
        if (numberOfFlaggedTasks >= minFlags && numberOfFlaggedTasks <= maxFlags)
            return riskProfile.getValueFor(getType());

        return 0;
    }

    @Override
    public RiskAssessment execute(final Release release, final RiskProfile riskProfile) {
        RiskAssessment assessment = new RiskAssessment();
        assessment.setRiskAssessorId(this.getId());
        return executeForFlag(assessment, release, riskProfile, FlagStatus.ATTENTION_NEEDED, TASKS_NEED_ATTENTION_HEADLINE);
    }

}
