package com.xebialabs.xlrelease.domain;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.status.TriggerExecutionStatus;

import static com.xebialabs.xlrelease.domain.ScriptHelper.HIDDEN;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned = false, virtual = true)
public abstract class Trigger extends BasePythonScript implements CiWithUid, TenantAwareCi {
    public static final String ALLOW_PARALLEL_EXECUTION = "allowParallelExecution";

    private Integer ciUid;

    private String tenantId;

    @PublicApiMember
    @Property(description = "Symbolic name for the trigger")
    private String title;

    @Property(required = false, description = "The description of the trigger.", size = Property.Size.LARGE)
    private String description;

    @PublicApiMember
    @Property(defaultValue = "true", required = false)
    private boolean enabled = true;

    @PublicApiMember
    @Property(required = false, category = HIDDEN)
    private String triggerState = "";

    @Property(required = false, category = HIDDEN, isTransient = true, defaultValue = "", description = "Folder that the trigger belongs to.")
    private String folderId = "";

    @Property(category = HIDDEN, defaultValue = "false", isTransient = true,
            description = "Allows parallel execution of triggers (ie parallel processing of execute requests/scripts).")
    protected boolean allowParallelExecution = false;

    @Property(required = false, category = HIDDEN, description = "Last run date.")
    private Date lastRunDate;

    @Property(required = false, category = HIDDEN, description = "Last run execution status.")
    private TriggerExecutionStatus lastRunStatus;

    @Override
    public Integer getCiUid() {
        return ciUid;
    }

    @Override
    public void setCiUid(final Integer ciUid) {
        this.ciUid = ciUid;
    }

    @Override
    public String getTenantId() {
        return tenantId;
    }

    @Override
    public void setTenantId(final String tenantId) {
        this.tenantId = tenantId;
    }

    public List<String> getInternalProperties() {
        return Arrays.asList("lastRunDate", "lastRunStatus", "triggerState");
    }

    @PublicApiMember
    public String getTitle() {
        return title;
    }

    @PublicApiMember
    public void setTitle(String title) {
        this.title = title;
    }

    @PublicApiMember
    public String getDescription() {
        return description;
    }

    @PublicApiMember
    public void setDescription(final String description) {
        this.description = description;
    }

    @PublicApiMember
    public boolean isEnabled() {
        return enabled;
    }

    @PublicApiMember
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getTriggerState() {
        return triggerState;
    }

    public void setTriggerState(String triggerState) {
        this.triggerState = triggerState;
    }

    public String getFolderId() {
        return folderId;
    }

    public void setFolderId(final String folderId) {
        this.folderId = folderId;
    }

    public boolean getAllowParallelExecution() {
        return allowParallelExecution;
    }

    public void setAllowParallelExecution(final boolean allowParallelExecution) {
        this.allowParallelExecution = allowParallelExecution;
    }

    public Date getLastRunDate() {
        return lastRunDate;
    }

    public void setLastRunDate(Date lastRunDate) {
        this.lastRunDate = lastRunDate;
    }

    public TriggerExecutionStatus getLastRunStatus() {
        return lastRunStatus;
    }

    public void setLastRunStatus(TriggerExecutionStatus lastRunStatus) {
        this.lastRunStatus = lastRunStatus;
    }

    public abstract String getContainerId();
}
