package com.xebialabs.xlrelease.domain.events

import com.xebialabs.xlrelease.domain.UserProfile


sealed trait UserProfileEvent extends XLReleaseEvent

/**
  * Event published when a new user profile is created.
  * @param profile the created user profile.
  */
case class UserProfileCreatedEvent(profile: UserProfile) extends UserProfileEvent

/**
  * Event published when a user profile is updated.
  * @param profile the updated profile.
  */
case class UserProfileUpdatedEvent(profile: UserProfile) extends UserProfileEvent

/**
  * Event published when a user profile is deleted.
  * @param profile the deleted profile.
  */
case class UserProfileDeletedEvent(profile: UserProfile) extends UserProfileEvent
