package com.xebialabs.xlrelease.domain.variables.reference;

import java.util.function.Function;
import com.google.common.base.Joiner;

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;

import static com.xebialabs.xlrelease.variable.VariableHelper.formatVariableIfNeeded;
import static java.lang.String.format;
import static java.util.Arrays.stream;
import static java.util.Optional.ofNullable;

public enum ReleasePropertyVariableKey {

    ID("id", BaseConfigurationItem::getId),
    TITLE("title", PlanItem::getTitle),
    URL("url", release -> ofNullable(release.getUrl()).orElse(null)),
    STATUS("status", release -> ofNullable(release.getStatus()).map(ReleaseStatus::value).orElse(null)),
    OWNER("owner", PlanItem::getOwner),
    DESCRIPTION("description", PlanItem::getDescription),
    FLAG_STATUS("flagStatus", release -> ofNullable(release.getFlagStatus()).map(Enum::toString).orElse(null)),
    FLAG_COMMENT("flagComment", PlanItem::getFlagComment),
    TAGS("tags", release -> ofNullable(release.getTags()).map(tags -> Joiner.on(", ").join(tags)).orElse(null));

    private String key;
    private Function<Release, String> valueGetter;

    ReleasePropertyVariableKey(final String propertyName, final Function<Release, String> valueGetter) {
        this.key = format("${release.%s}", propertyName);
        this.valueGetter = valueGetter;
    }

    public String getKey() {
        return key;
    }

    public String getValue(Release release) {
        return valueGetter.apply(release);
    }

    public static boolean isReleasePropertyVariableKey(String key) {
        return stream(ReleasePropertyVariableKey.values())
                .map(ReleasePropertyVariableKey::getKey)
                .anyMatch(k -> k.equals(formatVariableIfNeeded(key)));
    }
}
