package com.xebialabs.xlrelease.domain.variables.reference;

import java.util.*;
import java.util.stream.Collectors;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.api.v1.forms.VariableOrValue;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.VariableReference.VariableUsageType;
import com.xebialabs.xlrelease.repository.CiProperty;
import com.xebialabs.xlrelease.variable.VariableHelper;

import static com.xebialabs.xlrelease.variable.VariableHelper.withoutVariableSyntax;

/**
 * This usage point means that variable is referenced by user input task variables property i.e. a
 * variables property of type {@code List<Variable>}
 */
public class UserInputTaskUsagePoint implements UsagePoint {
    private final CiProperty property;
    private final UserInputTask task;
    private Variable variable;

    public UserInputTaskUsagePoint(final UserInputTask task, final String property, final Variable variable) {
        this.task = task;
        this.property = CiProperty.of(task, property).get();
        this.variable = variable;
    }

    @Override
    public Map<String, VariableUsageType> collectVariables() {
        final Map<String, VariableUsageType> vars = new HashMap<>();
        vars.put(VariableHelper.withVariableSyntax(variable.getKey()), VariableUsageType.DEFAULT);
        return vars;
    }

    @Override
    public Set<ConfigurationItem> replaceVariable(final Variable variable, final VariableOrValue replacement) {
        Set<ConfigurationItem> modifiedItems = new HashSet<>();
        if (null != replacement.getVariable()) {
            String replacementVariableKey = withoutVariableSyntax(replacement.getVariable());
            Variable newVariable = task.getRelease().getVariablesByKeys().get(replacementVariableKey);

            if (null == newVariable) {
                removeVariableFromTask(variable);
            } else {
                List<Variable> newTaskVariables = task.getVariables().stream().map(v -> v.getKey().equals(variable.getKey()) ? newVariable : v).distinct().collect(Collectors.toList());
                task.setVariables(newTaskVariables);
            }
        } else {
            removeVariableFromTask(variable);
        }
        modifiedItems.add(task);
        return modifiedItems;
    }

    private boolean removeVariableFromTask(Variable variable) {
        return task.getVariables().removeIf(v -> v.getKey().equals(variable.getKey()));
    }

    @Override
    public CiProperty getTargetProperty() {
        return property;
    }
}
