package com.xebialabs.xlrelease.domain.versioning.ascode.validation;

import java.util.Objects;

import com.xebialabs.xlrelease.domain.versioning.ascode.CiInfo;

public class HardcodedPassword implements ValidationMessage {
    private final CiInfo ci;
    private final String property;

    public HardcodedPassword(CiInfo ci, String property) {
        this.ci = ci;
        this.property = property;
    }

    @Override
    public CiInfo getCi() {
        return ci;
    }

    @Override
    public String getProperty() {
        return property;
    }

    @Override
    public String getMessage() {
        return "Contains a hardcoded password, please use a global or folder variable in a parent folder instead.";
    }

    @Override
    public String getMessageType() {
        return "HARDCODED_PASSWORD";
    }

    @Override
    public String getMessageLevel() {
        return ValidationMessage.LEVEL_WARN;
    }

    @Override
    public boolean equals(final Object o) {
        if (o == null || getClass() != o.getClass()) return false;
        final HardcodedPassword that = (HardcodedPassword) o;
        return Objects.equals(ci, that.ci) && Objects.equals(property, that.property);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ci, property);
    }
}
