package com.xebialabs.xlrelease.domain.versioning.ascode.validation;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.versioning.ascode.CiInfo;

@PublicApiRef
public final class ValidationReportMessageUtil {

    private ValidationReportMessageUtil() {
    }

    public static ExternalDependencyReportMessage validationMessageToReportMessage(ValidationMessage msg) {
        ExternalDependencyReportMessage report = new ExternalDependencyReportMessage();
        if (msg instanceof NonVersionedRef nonVersionedRef) {
            report.setDependency(nonVersionedRef.getRef());
        }

        report.setMessageType(msg.getMessageType());
        report.setMessage(msg.getMessage());
        report.setId(msg.getCi().getId());
        report.setFolder(msg.getCi().getFolderPath());
        report.setFolderId(msg.getCi().getFolderId());
        report.setTitle(msg.getCi().getTitle());
        report.setCiType(msg.getCi().getCiType());
        report.setCiTypeDisplayName(msg.getCi().getCiTypeDisplayName());
        report.setProperty(msg.getProperty());
        if (report.getDependency() == null) {
            report.setDependency(new CiInfo(
                    msg.getCi().getId(),
                    msg.getCi().getCiType(),
                    msg.getCi().getCiTypeDisplayName(),
                    msg.getCi().getFolderPath(),
                    msg.getCi().getFolderId(),
                    msg.getCi().getTitle()
            ));
        }

        return report;
    }
}
