package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

import java.util.ArrayList;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.xebialabs.xlrelease.repository.Ids.isConfigurationId;
import static java.util.Arrays.asList;

/**
 * Base class for configuration and all global settings in the application.
 */
@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, versioned = false, virtual = true)
public class BaseConfiguration extends BaseConfigurationItem {

    @Property(description = "If set, this field contains the folder that this configuration belongs to.", required = false, category = "FOLDER_CONFIG")
    private String folderId;

    private Integer ciUid;

    @PublicApiMember
    public String getFolderId() {
        return folderId;
    }

    @PublicApiMember
    public void setFolderId(final String folderId) {
        this.folderId = folderId;
    }

    public boolean hasId() {
        return !isNullOrEmpty(getId()) && isConfigurationId(getId());
    }

    // abstract methods to be overridden by children which might have a title
    public String getTitle() {
        return null;
    }

    public void setTitle(String title) {
    }

    @Property(description = "List of supported scopes for this configuration", defaultValue = "global,folder", hidden = true)
    private List<String> supportedScopes = new ArrayList<>(asList(BaseConfigurationScope.FOLDER.getValue(), BaseConfigurationScope.GLOBAL.getValue()));

    public boolean isSupportedOn(BaseConfigurationScope scope) {
        List<String> scopes = (List<String>) getType().getDescriptor().getPropertyDescriptor("supportedScopes").getDefaultValue();
        return scopes.contains(scope.getValue());
    }

    public Integer getCiUid() {
        return ciUid;
    }

    public void setCiUid(final Integer ciUid) {
        this.ciUid = ciUid;
    }
}
