package com.xebialabs.xlrelease.domain;

import com.xebialabs.xlrelease.events.TaskStartOrRetryOperation;
import com.xebialabs.xlrelease.service.PostAction;

import static com.xebialabs.xlrelease.domain.status.TaskStatus.IN_PROGRESS;

public abstract class BaseScriptTask extends Task {

    protected Changes executeScript(String targetId, TaskStartOrRetryOperation operation, PostAction postAction) {
        Changes changes = super.execute(targetId, operation);

        if (getStatus() != IN_PROGRESS) {
            return changes;
        }

        generateExecutionId();
        changes.addPostAction(postAction);
        return changes;
    }

    public abstract String getEngine();
}
