package com.xebialabs.xlrelease.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

import static com.xebialabs.xlrelease.domain.ScriptHelper.HIDDEN;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned = false, virtual = true)
public abstract class ScheduledTrigger extends Trigger {

    @PublicApiMember
    @Property(defaultValue = "REPEAT", required = true, label = "Poll type", description = "Type of polling to use; this is a repeatable period in seconds (for example, every 10 seconds) or a cron expression")
    private PollType pollType = PollType.REPEAT;

    @PublicApiMember
    @Property(defaultValue = "60", required = true, label = "Poll interval", description = "Interval in seconds (REPEAT) or as a cron expression (CRON). The cron pattern is a list of six fields separated by a single space; these fields represent second, minute, hour, day, month, weekday. Month and weekday names can be given as the first three letters of their English names. For example: 0 0 * * * * = the top of every hour of every day; */10 * * * * * = every ten seconds; 0 0 9-17 * * MON-FRI = on the hour nine-to-five weekdays")
    private String periodicity = "60";

    @PublicApiMember
    @Property(required = false, category = HIDDEN, defaultValue = "false", description = "Set this property to true to trigger a new release on the initial trigger fire. Otherwise, the first release will be triggered on the next state change")
    private boolean initialFire = false;

    @Property(
            category = "PollTypeDependentProperties",
            hidden = true,
            required = false,
            defaultValue = "CRON:misfireRecoveryEnabled"
    )
    private Map<String, String> pollType_DependentProperties;

    @PublicApiMember
    @Property(
            defaultValue = "false",
            category = "PollTypeDependentProperties",
            label = "Missed event detection",
            description = "Determines how to handle missed execution, for example in the case of the server being down. When enabled, the trigger is activated once when the system detects it has missed events. If disabled, missed events are ignored."
    )
    private boolean misfireRecoveryEnabled = false;

    @Override
    public List<String> getInternalProperties() {
        ArrayList<String> properties = new ArrayList<>(super.getInternalProperties());
        properties.add("initialFire");
        return properties;
    }

    @PublicApiMember
    public PollType getPollType() {
        return pollType;
    }

    @PublicApiMember
    public void setPollType(final PollType pollType) {
        this.pollType = pollType;
    }

    @PublicApiMember
    public String getPeriodicity() {
        return periodicity;
    }

    @PublicApiMember
    public void setPeriodicity(final String periodicity) {
        this.periodicity = periodicity;
    }

    public boolean isInitialFire() {
        return initialFire;
    }

    public void setInitialFire(final boolean initialFire) {
        this.initialFire = initialFire;
    }

    @PublicApiMember
    public boolean isMisfireRecoveryEnabled() {
        return this.misfireRecoveryEnabled;
    }

    @PublicApiMember
    public void setMisfireRecoveryEnabled(final boolean misfireRecoveryEnabled) {
        this.misfireRecoveryEnabled = misfireRecoveryEnabled;
    }
}
