package com.xebialabs.xlrelease.domain;

import java.util.ArrayList;
import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UserInputTaskUsagePoint;

import static java.util.stream.Collectors.toList;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label = "User Input", versioned = false, description = "Prompts users for information or decisions")
public class UserInputTask extends Task {

    @SuppressWarnings("DefaultAnnotationParam")
    @Property(asContainment = false)
    protected List<Variable> variables = new ArrayList<>();

    @Property(defaultValue = "how-to/create-a-user-input-task", hidden = true, required = false)
    private String documentationPage;

    @Override
    public void applyDefaults() {
        this.description = "Please enter the required information below.";
    }

    @Override
    public List<Variable> getReferencedVariables() {
        List<Variable> referencedVariables = new ArrayList<>(super.getReferencedVariables());
        variables.stream()
            .filter(variable -> !referencedVariables.contains(variable))
            .forEach(referencedVariables::add);
        return referencedVariables;
    }

    @PublicApiMember
    public List<Variable> getVariables() {
        return variables;
    }

    @PublicApiMember
    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public Changes removeVariable(final String variableId) {
        Changes changes = new Changes();
        variables.removeIf(variable -> variableId.equals(variable.getId()));
        changes.remove(variableId);
        changes.update(this);
        return changes;
    }

    @Override
    public List<UsagePoint> getVariableUsages() {
        ArrayList<UsagePoint> usagePoints = new ArrayList<>(super.getVariableUsages());
        usagePoints.addAll(getVariables().stream().map(v -> new UserInputTaskUsagePoint(this, "variables", v)).collect(toList()));
        return usagePoints;
    }

}
