package com.xebialabs.xlrelease.domain

import com.fasterxml.jackson.databind.annotation.JsonSerialize
import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.xlrelease.serialization.json.jackson.CiSerializer
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import java.util.{Date, HashSet => JHashSet, Set => JSet}
import scala.beans.BeanProperty

/**
 * This class represents a personal access token data for the user.
 * Table also has token hash value which is not added in domain class to prevent any potential leak in logs, events etc.
 */
@JsonSerialize(using = classOf[CiSerializer])
@Metadata(root = Metadata.ConfigurationItemRoot.CONFIGURATION, versioned = false)
class UserToken extends BaseConfigurationItem {

  @BeanProperty
  @XLProperty
  var ciUid: Integer = _

  @BeanProperty
  @XLProperty
  var username: String = _

  @BeanProperty
  @XLProperty
  var tokenNote: String = _

  @BeanProperty
  @XLProperty
  var createdDate: Date = _

  @BeanProperty
  @XLProperty
  var lastUsedDate: Date = _

  @BeanProperty
  @XLProperty
  var expiryDate: Date = _

  @BeanProperty
  @XLProperty
  var expiryNotified: Boolean = _

  @BeanProperty
  @XLProperty(readonly = true, nested = true, required = false)
  var userTokenPermission: UserTokenPermission = _

  @XLProperty(isTransient = true, required = false, readonly = true)
  var token: String = _

  override def toString: String = s"UserToken {username=$username, tokenNote:$tokenNote}"

  def isExpired(): Boolean = null != expiryDate && expiryDate.getTime < System.currentTimeMillis()
}

@JsonSerialize(using = classOf[CiSerializer])
@Metadata(versioned = false)
class UserTokenPermission extends BaseConfigurationItem {
  @BeanProperty
  @XLProperty(required = false)
  var globalPermissions: JSet[String] = new JHashSet[String]()
}
