package com.xebialabs.xlrelease.domain.variables;

import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.utils.DateVariableUtils;

import java.util.Date;

import static java.lang.String.format;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class DateVariable extends Variable.VariableWithValue<Date> {

    @PublicApiMember
    @Property(required = false, description = "Value of the release variable or default value of the template variable")
    protected Date value;

    @PublicApiMember
    @Override
    public Date getValue() {
        return value;
    }

    @Override
    public Date getEmptyValue() {
        return null;
    }

    @PublicApiMember
    @Override
    public void setValue(final Date value) {
        this.value = value;
    }

    @Override
    public void setUntypedValue(final Object newValue) throws IllegalArgumentException {
        if (newValue instanceof Date) {
            this.setValue((Date) newValue);
        } else if (newValue instanceof Long || newValue instanceof Integer) {
            try {
                this.setValue(new Date(((Number) newValue).longValue()));
            } catch (NumberFormatException ex) {
                throw new IllegalArgumentException(format("Cannot set instance of %s into date variable value: %s", newValue.getClass().getSimpleName(), newValue));
            }
        } else if (newValue instanceof String) {
            this.setValue(DateVariableUtils.parseDate((String) newValue));
        } else if (newValue == null) {
            this.setValue(this.getEmptyValue());
        } else {
            throw new IllegalArgumentException(format("Cannot set instance of %s into date variable value: %s", newValue.getClass().getSimpleName(), newValue));
        }
    }

    @Override
    public boolean isPassword() {
        return false;
    }

    @Override
    public String getValueAsString() {
        return isValueEmpty() ? getEmptyValueAsString() : DateVariableUtils.printDate(value);
    }

    @Override
    public String getEmptyValueAsString() {
        return "";
    }

    @Override
    public boolean isValueAssignableFrom(final Object value) {
        return value instanceof Date;
    }

}
