package com.xebialabs.xlrelease.domain.variables;

import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;

import java.util.List;

import static java.lang.String.format;
import static org.springframework.util.StringUtils.hasLength;


public class ReferenceVariable extends StringVariable {

    public static final String VARIABLE_DELEGATE = "RESOLVE_VARIABLE_VALUE";

    @PublicApiMember
    @Property(required = true, description = "The type of the reference, ie: jenkins.Server")
    protected String referencedType;

    public String getReferencedType() {
        return referencedType;
    }

    public void setReferencedType(String referencedType) {
        this.referencedType = referencedType;
    }

    @Override
    public void setUntypedValue(Object newValue) throws IllegalArgumentException {
        if (newValue instanceof String) {
            this.setValue((String) newValue);
        } else if (newValue == null) {
            this.setValue(this.getEmptyValue());
        } else {
            throw new IllegalArgumentException(format("Cannot set instance of %s into ReferenceVariable variable value: %s", newValue.getClass().getSimpleName(), newValue));
        }
    }

    @Override
    public void setValueProvider(ValueProviderConfiguration valueProvider) {
        // we only allow if you are setting it, so we don't override it on com.xebialabs.xlrelease.domain.variables.Variable.setValueProvider
        if (valueProvider != null) {
            super.setValueProvider(valueProvider);
        }
    }

    @Override
    @ControlTask(delegate = VARIABLE_DELEGATE)
    public Object getInternalValue() {
        if (!hasLength(this.value)) {
            return null;
        }
        List<Object> cis = this.getType().getDescriptor().getControlTask("getInternalValue").invoke(this);
        if (cis.isEmpty()) {
            throw new IllegalStateException(String.format("Unable to resolve reference %s of type %s for variable ${%s}", this.value, this.referencedType, this.key));
        }
        return cis.get(0);
    }

}
