package com.xebialabs.xlrelease.domain.versioning.ascode

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.domain._
import com.xebialabs.xlrelease.domain.delivery.Delivery
import com.xebialabs.xlrelease.domain.variables.Variable
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.FolderInfo
import com.xebialabs.xlrelease.plugins.dashboard.domain.{Dashboard, Tile}

import scala.beans.BeanProperty

case class CiInfo(
                   @BeanProperty id: String,
                   @BeanProperty ciType: String,
                   @BeanProperty ciTypeDisplayName: String,
                   @BeanProperty folderPath: String,
                   @BeanProperty folderId: String,
                   @BeanProperty title: String
                 ) {
  def withCiId(newId: String): CiInfo = {
    this.copy(newId, ciType, ciTypeDisplayName, folderPath, folderId, title)
  }
}

object CiInfo {
  def apply(ci: ConfigurationItem, folder: FolderInfo, parentCiInfo: Option[CiInfo] = None): CiInfo = {
    new CiInfo(
      ci.getId,
      ci.getType.toString,
      getTypeDisplayName(ci),
      folder.getRelativePath,
      folder.getId,
      getTitle(ci, parentCiInfo)
    )
  }

  // scalastyle:off cyclomatic.complexity
  private def getTypeDisplayName(ci: ConfigurationItem): String = {
    ci match {
      case _: Task => "Task"
      case _: Phase => "Phase"
      case _: Release => "Template"
      case _: Variable => "Variable"
      case _: Configuration => "Connection"
      case _: Trigger => "Trigger"
      case _: Delivery => "Pattern"
      case _: Dashboard => "Dashboard"
      case _: Tile => "Tile"
      case _ => ci.getType.getName // Won't necessarily be user friendly but better than nothing
    }
  }

  private def getTitle(ci: ConfigurationItem, parentCiInfo: Option[CiInfo]): String = {
    val title = ci match {
      case planItem: PlanItem => planItem.getTitle
      case variable: Variable => variable.getKey
      case configuration: Configuration => configuration.getTitle
      case trigger: Trigger => trigger.getTitle
      case pattern: Delivery => pattern.getTitle
      case dashboard: Dashboard => dashboard.getTitle
      case tile: Tile => tile.getTitle
      case _ => "Unknown"
    }

    parentCiInfo match {
      case Some(parent) => s"${parent.title}/$title"
      case None => title
    }
  }
}
