package com.xebialabs.xlrelease.domain.versioning.ascode.settings;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Range;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.configuration.connector.Repository;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.xebialabs.xlrelease.domain.versioning.ascode.settings.FolderVersioningSettingsUtil.CATEGORY_INTERNAL;

@PublicApiRef
@Metadata(label = "As-code Versioning", description = "", virtual = false)
public class FolderVersioningSettings extends BaseConfiguration {

    @Property(label = "Git connection", description = "Git connection to use")
    private Repository gitConnection;

    @Property(label = "SCM Path", description = "Path on the SCM where the as-code YAML is located")
    private String scmPath = "";

    @Property(required = true, label = "Branch", description = "Override branch setting")
    private String branch = "master";

    @Property(defaultValue = "true", description = "Export templates into the as-code YAML", category = "Export")
    private boolean exportTemplates = true;

    @Property(defaultValue = "true", description = "Export workflows into the as-code YAML", category = "Export")
    private boolean exportWorkflows = true;

    @Property(defaultValue = "true", description = "Export pattern into the as-code YAML", category = "Export")
    private boolean exportPatterns = true;

    @Property(defaultValue = "true", description = "Export variables into the as-code YAML", category = "Export")
    private boolean exportVariables = true;

    @Property(defaultValue = "true", description = "Export triggers into the as-code YAML", category = "Export")
    private boolean exportTriggers = true;

    @Property(defaultValue = "true", description = "Export connections into the as-code YAML", category = "Export")
    private boolean exportConfiguration = true;

    @Property(defaultValue = "true", description = "Export dashboards into the as-code YAML", category = "Export")
    private boolean exportDashboards = true;

    @Property(defaultValue = "true", description = "Export notifications into the as-code YAML", category = "Export")
    private boolean exportNotifications = true;

    @Property(defaultValue = "false", description = "Export teams and permissions into the as-code YAML", category = "Export")
    private boolean exportSecurity = false;

    @Property(defaultValue = "false", description = "Export applications into the as-code YAML", category = "Export")
    private boolean exportApplications = false;

    @Property(defaultValue = "false", description = "Export environments into the as-code YAML", category = "Export")
    private boolean exportEnvironments = false;

    @Property(category = "internal", required = false)
    private Date lastFetched;

    @Property(category = "internal", required = false)
    private String appliedVersion = "";

    @Property(category = "internal", required = false)
    private Date appliedDate;

    @Property(category = "internal", required = false)
    private String appliedBy = "";

    @Property(category = "internal", required = false, password = true)
    private Map<String, String> secrets = new HashMap<>();

    @Property(defaultValue = "multipleFilesPerCIType")
    private String versioningStyle = "";

    @Property(required = false, defaultValue = "false", description = "Automatically apply a new version")
    private boolean autoImport = false;

    @Property(required = true, defaultValue = "720", description = "Version poll interval in minutes to automatically apply a new version")
    @Range(minimum = 10)
    private int pollDuration;

    public void updateWith(FolderVersioningSettings newConfig) {
        for (PropertyDescriptor property : getEditableProperties()) {
            property.set(this, property.get(newConfig));
        }
    }

    private List<PropertyDescriptor> getEditableProperties() {
        return getType().getDescriptor().getPropertyDescriptors().stream()
                .filter(property -> !CATEGORY_INTERNAL.equals(property.getCategory()))
                .toList();
    }

    public Repository getGitConnection() {
        return gitConnection;
    }

    public void setGitConnection(Repository gitConnection) {
        this.gitConnection = gitConnection;
    }

    public String getScmPath() {
        return scmPath;
    }

    public void setScmPath(String scmPath) {
        this.scmPath = scmPath;
    }

    public String getBranch() {
        return branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public boolean getExportTemplates() {
        return exportTemplates;
    }

    public void setExportTemplates(boolean exportTemplates) {
        this.exportTemplates = exportTemplates;
    }

    public boolean getExportWorkflows() {
        return exportWorkflows;
    }

    public void setExportWorkflows(boolean exportWorkflows) {
        this.exportWorkflows = exportWorkflows;
    }

    public boolean getExportPatterns() {
        return exportPatterns;
    }

    public void setExportPatterns(boolean exportPatterns) {
        this.exportPatterns = exportPatterns;
    }

    public boolean getExportVariables() {
        return exportVariables;
    }

    public void setExportVariables(boolean exportVariables) {
        this.exportVariables = exportVariables;
    }

    public boolean getExportTriggers() {
        return exportTriggers;
    }

    public void setExportTriggers(boolean exportTriggers) {
        this.exportTriggers = exportTriggers;
    }

    public boolean getExportConfiguration() {
        return exportConfiguration;
    }

    public void setExportConfiguration(boolean exportConfiguration) {
        this.exportConfiguration = exportConfiguration;
    }

    public boolean getExportDashboards() {
        return exportDashboards;
    }

    public void setExportDashboards(boolean exportDashboards) {
        this.exportDashboards = exportDashboards;
    }

    public boolean getExportNotifications() {
        return exportNotifications;
    }

    public void setExportNotifications(boolean exportNotifications) {
        this.exportNotifications = exportNotifications;
    }

    public boolean getExportSecurity() {
        return exportSecurity;
    }

    public void setExportSecurity(boolean exportSecurity) {
        this.exportSecurity = exportSecurity;
    }

    public boolean getExportApplications() {
        return exportApplications;
    }

    public void setExportApplications(boolean exportApplications) {
        this.exportApplications = exportApplications;
    }

    public boolean getExportEnvironments() {
        return exportEnvironments;
    }

    public void setExportEnvironments(boolean exportEnvironments) {
        this.exportEnvironments = exportEnvironments;
    }

    public Date getLastFetched() {
        return lastFetched;
    }

    public void setLastFetched(Date lastFetched) {
        this.lastFetched = lastFetched;
    }

    public String getAppliedVersion() {
        return appliedVersion;
    }

    public void setAppliedVersion(String appliedVersion) {
        this.appliedVersion = appliedVersion;
    }

    public Date getAppliedDate() {
        return appliedDate;
    }

    public void setAppliedDate(Date appliedDate) {
        this.appliedDate = appliedDate;
    }

    public String getAppliedBy() {
        return appliedBy;
    }

    public void setAppliedBy(String appliedBy) {
        this.appliedBy = appliedBy;
    }

    public Map<String, String> getSecrets() {
        return secrets;
    }

    public void setSecrets(Map<String, String> secrets) {
        this.secrets = secrets;
    }

    public String getVersioningStyle() {
        return versioningStyle;
    }

    public void setVersioningStyle(String versioningStyle) {
        this.versioningStyle = versioningStyle;
    }

    public boolean getAutoImport() {
        return autoImport;
    }

    public void setAutoImport(boolean autoImport) {
        this.autoImport = autoImport;
    }

    public int getPollDuration() {
        return pollDuration;
    }

    public void setPollDuration(int pollDuration) {
        this.pollDuration = pollDuration;
    }
}

